/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.shared.platform;

import com.google.auto.service.AutoService;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.authlib.GameProfile;
import com.mojang.brigadier.arguments.ArgumentType;
import dan200.computercraft.api.media.IMedia;
import dan200.computercraft.api.media.MediaLookup;
import dan200.computercraft.api.network.wired.WiredElement;
import dan200.computercraft.api.node.wired.WiredElementLookup;
import dan200.computercraft.api.peripheral.IPeripheral;
import dan200.computercraft.api.peripheral.PeripheralLookup;
import dan200.computercraft.impl.Peripherals;
import dan200.computercraft.mixin.ArgumentTypeInfosAccessor;
import dan200.computercraft.shared.config.ConfigFile;
import dan200.computercraft.shared.network.MessageType;
import dan200.computercraft.shared.network.NetworkMessage;
import dan200.computercraft.shared.network.client.ClientNetworkContext;
import dan200.computercraft.shared.network.container.ContainerData;
import dan200.computercraft.shared.platform.ComponentAccess;
import dan200.computercraft.shared.platform.ContainerTransfer;
import dan200.computercraft.shared.platform.FabricConfigFile;
import dan200.computercraft.shared.platform.FabricContainerTransfer;
import dan200.computercraft.shared.platform.FabricMessageType;
import dan200.computercraft.shared.platform.FakePlayer;
import dan200.computercraft.shared.platform.MoreConventionalTags;
import dan200.computercraft.shared.platform.PlatformHelper;
import dan200.computercraft.shared.platform.RecipeIngredients;
import dan200.computercraft.shared.platform.RegistrationHelper;
import dan200.computercraft.shared.platform.RegistryEntry;
import dan200.computercraft.shared.platform.RegistryWrappers;
import dan200.computercraft.shared.util.InventoryUtil;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import net.fabricmc.fabric.api.event.player.AttackEntityCallback;
import net.fabricmc.fabric.api.event.player.UseBlockCallback;
import net.fabricmc.fabric.api.event.player.UseEntityCallback;
import net.fabricmc.fabric.api.itemgroup.v1.FabricItemGroup;
import net.fabricmc.fabric.api.lookup.v1.block.BlockApiCache;
import net.fabricmc.fabric.api.lookup.v1.block.BlockApiLookup;
import net.fabricmc.fabric.api.networking.v1.PacketByteBufs;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.fabricmc.fabric.api.object.builder.v1.block.entity.FabricBlockEntityTypeBuilder;
import net.fabricmc.fabric.api.registry.FuelRegistry;
import net.fabricmc.fabric.api.resource.conditions.v1.DefaultResourceConditions;
import net.fabricmc.fabric.api.resource.conditions.v1.ResourceConditions;
import net.fabricmc.fabric.api.screenhandler.v1.ExtendedScreenHandlerFactory;
import net.fabricmc.fabric.api.screenhandler.v1.ExtendedScreenHandlerType;
import net.fabricmc.fabric.api.tag.convention.v1.ConventionalItemTags;
import net.fabricmc.fabric.api.transfer.v1.item.InventoryStorage;
import net.fabricmc.fabric.api.transfer.v1.item.ItemStorage;
import net.fabricmc.fabric.api.transfer.v1.item.ItemVariant;
import net.fabricmc.fabric.api.transfer.v1.storage.SlottedStorage;
import net.fabricmc.fabric.api.transfer.v1.storage.Storage;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_1263;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1270;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1761;
import net.minecraft.class_1792;
import net.minecraft.class_1794;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1821;
import net.minecraft.class_1856;
import net.minecraft.class_1860;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2314;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2378;
import net.minecraft.class_243;
import net.minecraft.class_2540;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_2596;
import net.minecraft.class_2602;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3489;
import net.minecraft.class_3518;
import net.minecraft.class_3908;
import net.minecraft.class_3917;
import net.minecraft.class_3965;
import net.minecraft.class_3966;
import net.minecraft.class_5321;
import net.minecraft.class_6862;
import net.minecraft.class_7923;
import net.minecraft.class_8566;
import org.jspecify.annotations.Nullable;

@AutoService(value={dan200.computercraft.impl.PlatformHelper.class})
public class PlatformHelperImpl
implements PlatformHelper {
    @Override
    public boolean isDevelopmentEnvironment() {
        return FabricLoader.getInstance().isDevelopmentEnvironment();
    }

    @Override
    public ConfigFile.Builder createConfigBuilder() {
        return new FabricConfigFile.Builder();
    }

    private static <T> class_2378<T> getRegistry(class_5321<class_2378<T>> id) {
        class_2378 registry = (class_2378)class_7923.field_41167.method_10223(id.method_29177());
        if (registry == null) {
            throw new IllegalArgumentException("Unknown registry " + String.valueOf(id));
        }
        return registry;
    }

    @Override
    public <T> class_2960 getRegistryKey(class_5321<class_2378<T>> registry, T object) {
        class_2960 key = PlatformHelperImpl.getRegistry(registry).method_10221(object);
        if (key == null) {
            throw new IllegalArgumentException(String.valueOf(object) + " was not registered in " + String.valueOf(registry));
        }
        return key;
    }

    @Override
    public <T> T getRegistryObject(class_5321<class_2378<T>> registry, class_2960 id) {
        Object value = PlatformHelperImpl.getRegistry(registry).method_10223(id);
        if (value == null) {
            throw new IllegalArgumentException(String.valueOf(id) + " was not registered in " + String.valueOf(registry));
        }
        return (T)value;
    }

    @Override
    public <T> RegistryWrappers.RegistryWrapper<T> wrap(class_5321<class_2378<T>> registry) {
        return new RegistryWrapperImpl<T>(registry.method_29177(), PlatformHelperImpl.getRegistry(registry));
    }

    @Override
    public <T> RegistrationHelper<T> createRegistrationHelper(class_5321<class_2378<T>> registry) {
        return new RegistrationHelperImpl<T>(PlatformHelperImpl.getRegistry(registry));
    }

    @Override
    public <T> @Nullable T tryGetRegistryObject(class_5321<class_2378<T>> registry, class_2960 id) {
        return (T)PlatformHelperImpl.getRegistry(registry).method_10223(id);
    }

    @Override
    public boolean shouldLoadResource(JsonObject object) {
        return ResourceConditions.objectMatchesConditions((JsonObject)object);
    }

    @Override
    public void addRequiredModCondition(JsonObject object, String modId) {
        JsonArray conditions = class_3518.method_15292((JsonObject)object, (String)"fabric:load_conditions", null);
        if (conditions == null) {
            conditions = new JsonArray();
            object.add("fabric:load_conditions", (JsonElement)conditions);
        }
        conditions.add((JsonElement)DefaultResourceConditions.allModsLoaded((String[])new String[]{modId}).toJson());
    }

    @Override
    public <T extends class_2586> class_2591<T> createBlockEntityType(BiFunction<class_2338, class_2680, T> factory, class_2248 block) {
        return FabricBlockEntityTypeBuilder.create(factory::apply, (class_2248[])new class_2248[0]).addBlock(block).build();
    }

    @Override
    public <A extends ArgumentType<?>, T extends class_2314.class_7217<A>, I extends class_2314<A, T>> I registerArgumentTypeInfo(Class<A> klass, I info) {
        ArgumentTypeInfosAccessor.classMap().put(klass, info);
        return info;
    }

    @Override
    public <C extends class_1703, T extends ContainerData> class_3917<C> createMenuType(Function<class_2540, T> reader, ContainerData.Factory<C, T> factory) {
        return new ExtendedScreenHandlerType((id, player, data) -> factory.create(id, player, (ContainerData)reader.apply(data)));
    }

    @Override
    public void openMenu(class_1657 player, class_2561 title, class_1270 menu, ContainerData data) {
        player.method_17355((class_3908)new WrappedMenuProvider(title, menu, data));
    }

    @Override
    public <T extends NetworkMessage<?>> MessageType<T> createMessageType(int id, class_2960 channel, Class<T> klass, class_2540.class_7461<T> reader) {
        return new FabricMessageType(channel, reader);
    }

    @Override
    public class_2596<class_2602> createPacket(NetworkMessage<ClientNetworkContext> message) {
        class_2540 buf = PacketByteBufs.create();
        message.write(buf);
        return ServerPlayNetworking.createS2CPacket((class_2960)FabricMessageType.toFabricType(message.type()).getId(), (class_2540)buf);
    }

    @Override
    public ComponentAccess<IPeripheral> createPeripheralAccess(class_2586 owner, Consumer<class_2350> invalidate) {
        return new PeripheralAccessImpl(owner, invalidate);
    }

    @Override
    public ComponentAccess<WiredElement> createWiredElementAccess(class_2586 owner, Consumer<class_2350> invalidate) {
        return new ComponentAccessImpl<WiredElement>(owner, WiredElementLookup.get());
    }

    @Override
    public boolean hasWiredElementIn(class_1937 level, class_2338 pos, class_2350 direction) {
        return WiredElementLookup.get().find(level, pos.method_10093(direction), (Object)direction.method_10153()) != null;
    }

    @Override
    public ContainerTransfer.Slotted wrapContainer(class_1263 container) {
        return FabricContainerTransfer.of((SlottedStorage<ItemVariant>)InventoryStorage.of((class_1263)container, null));
    }

    @Override
    public @Nullable ContainerTransfer getContainer(class_3218 level, class_2338 pos, class_2350 side) {
        Storage storage = (Storage)ItemStorage.SIDED.find((class_1937)level, pos, (Object)side);
        if (storage != null) {
            return FabricContainerTransfer.of((Storage<ItemVariant>)storage);
        }
        class_1263 entity = InventoryUtil.getEntityContainer(level, pos, side);
        return entity == null ? null : FabricContainerTransfer.of((SlottedStorage<ItemVariant>)InventoryStorage.of((class_1263)entity, (class_2350)side));
    }

    @Override
    public RecipeIngredients getRecipeIngredients() {
        return new RecipeIngredients(class_1856.method_8106((class_6862)ConventionalItemTags.REDSTONE_DUSTS), class_1856.method_8091((class_1935[])new class_1935[]{class_1802.field_8276}), class_1856.method_8091((class_1935[])new class_1935[]{class_1802.field_8745}), class_1856.method_8091((class_1935[])new class_1935[]{class_1802.field_20391}), class_1856.method_8106((class_6862)ConventionalItemTags.GLASS_PANES), class_1856.method_8106((class_6862)ConventionalItemTags.GOLD_INGOTS), class_1856.method_8091((class_1935[])new class_1935[]{class_1802.field_8494}), class_1856.method_8106((class_6862)ConventionalItemTags.IRON_INGOTS), class_1856.method_8106(MoreConventionalTags.SKULLS), class_1856.method_8106((class_6862)ConventionalItemTags.DYES), class_1856.method_8091((class_1935[])new class_1935[]{class_1802.field_8634}), class_1856.method_8106(MoreConventionalTags.WOODEN_CHESTS));
    }

    @Override
    public List<class_6862<class_1792>> getDyeTags() {
        return List.of(ConventionalItemTags.WHITE_DYES, ConventionalItemTags.ORANGE_DYES, ConventionalItemTags.MAGENTA_DYES, ConventionalItemTags.LIGHT_BLUE_DYES, ConventionalItemTags.YELLOW_DYES, ConventionalItemTags.LIME_DYES, ConventionalItemTags.PINK_DYES, ConventionalItemTags.GRAY_DYES, ConventionalItemTags.LIGHT_GRAY_DYES, ConventionalItemTags.CYAN_DYES, ConventionalItemTags.PURPLE_DYES, ConventionalItemTags.BLUE_DYES, ConventionalItemTags.BROWN_DYES, ConventionalItemTags.GREEN_DYES, ConventionalItemTags.RED_DYES, ConventionalItemTags.BLACK_DYES);
    }

    @Override
    public int getBurnTime(class_1799 stack) {
        Integer fuel = (Integer)FuelRegistry.INSTANCE.get((class_1935)stack.method_7909());
        return fuel == null ? 0 : fuel;
    }

    @Override
    public class_1761.class_7913 newCreativeModeTab() {
        return FabricItemGroup.builder();
    }

    @Override
    public class_1799 getCraftingRemainingItem(class_1799 stack) {
        return stack.getRecipeRemainder();
    }

    @Override
    public List<class_1799> getRecipeRemainingItems(class_3222 player, class_1860<class_8566> recipe, class_8566 container) {
        return recipe.method_8111((class_1263)container);
    }

    @Override
    public void onItemCrafted(class_3222 player, class_8566 container, class_1799 stack) {
    }

    @Override
    public boolean onNotifyNeighbour(class_1937 level, class_2338 pos, class_2680 block, class_2350 direction) {
        return true;
    }

    @Override
    public class_3222 createFakePlayer(class_3218 world, GameProfile name) {
        return FakePlayer.create(world, name);
    }

    @Override
    public boolean hasToolUsage(class_1799 stack) {
        class_1792 item = stack.method_7909();
        return item instanceof class_1821 || stack.method_31573(class_3489.field_42615) || item instanceof class_1794 || stack.method_31573(class_3489.field_42613);
    }

    @Override
    public class_1269 canAttackEntity(class_3222 player, class_1297 entity) {
        return ((AttackEntityCallback)AttackEntityCallback.EVENT.invoker()).interact((class_1657)player, player.method_37908(), class_1268.field_5808, entity, null);
    }

    @Override
    public boolean interactWithEntity(class_3222 player, class_1297 entity, class_243 hitPos) {
        return ((UseEntityCallback)UseEntityCallback.EVENT.invoker()).interact((class_1657)player, entity.method_37908(), class_1268.field_5808, entity, new class_3966(entity, hitPos)).method_23665() || entity.method_5664((class_1657)player, hitPos.method_1020(entity.method_19538()), class_1268.field_5808).method_23665() || player.method_7287(entity, class_1268.field_5808).method_23665();
    }

    @Override
    public PlatformHelper.UseOnResult useOn(class_3222 player, class_1799 stack, class_3965 hit) {
        class_1269 result = ((UseBlockCallback)UseBlockCallback.EVENT.invoker()).interact((class_1657)player, player.method_37908(), class_1268.field_5808, hit);
        if (result != class_1269.field_5811) {
            return new PlatformHelper.UseOnResult.Handled(result);
        }
        return new PlatformHelper.UseOnResult.Continue(true, true);
    }

    @Override
    public @Nullable IMedia getMedia(class_1799 stack) {
        return (IMedia)MediaLookup.get().find(stack, null);
    }

    private record RegistryWrapperImpl<T>(class_2960 name, class_2378<T> registry) implements RegistryWrappers.RegistryWrapper<T>
    {
        public int method_10206(T object) {
            return this.registry.method_10206(object);
        }

        @Override
        public class_2960 getKey(T object) {
            class_2960 key = this.registry.method_10221(object);
            if (key == null) {
                throw new IllegalArgumentException(String.valueOf(object) + " was not registered in " + String.valueOf(this.name));
            }
            return key;
        }

        @Override
        public T get(class_2960 location) {
            Object object = this.registry.method_10223(location);
            if (object == null) {
                throw new IllegalArgumentException(String.valueOf(location) + " was not registered in " + String.valueOf(this.name));
            }
            return (T)object;
        }

        @Override
        public @Nullable T tryGet(class_2960 location) {
            return (T)this.registry.method_10223(location);
        }

        public @Nullable T method_10200(int id) {
            return (T)this.registry.method_10200(id);
        }

        public int method_10204() {
            return this.registry.method_10204();
        }

        public Iterator<T> iterator() {
            return this.registry.iterator();
        }
    }

    private static final class RegistrationHelperImpl<T>
    implements RegistrationHelper<T> {
        private final class_2378<T> registry;
        private final List<RegistryEntryImpl<? extends T>> entries = new ArrayList<RegistryEntryImpl<? extends T>>();

        private RegistrationHelperImpl(class_2378<T> registry) {
            this.registry = registry;
        }

        @Override
        public <U extends T> RegistryEntry<U> register(String name, Supplier<U> create) {
            RegistryEntryImpl<U> entry = new RegistryEntryImpl<U>(new class_2960("computercraft", name), create);
            this.entries.add(entry);
            return entry;
        }

        @Override
        public void register() {
            for (RegistryEntryImpl<T> entry : this.entries) {
                entry.register(this.registry);
            }
        }
    }

    private record WrappedMenuProvider(class_2561 title, class_1270 menu, ContainerData data) implements ExtendedScreenHandlerFactory
    {
        public @Nullable class_1703 createMenu(int id, class_1661 inventory, class_1657 player) {
            return this.menu.createMenu(id, inventory, player);
        }

        public class_2561 method_5476() {
            return this.title;
        }

        public void writeScreenOpeningData(class_3222 player, class_2540 buf) {
            this.data.toBytes(buf);
        }
    }

    private static final class PeripheralAccessImpl
    extends ComponentAccessImpl<IPeripheral> {
        private final Runnable[] invalidators = new Runnable[6];

        private PeripheralAccessImpl(class_2586 owner, Consumer<class_2350> invalidate) {
            super(owner, PeripheralLookup.get());
            for (class_2350 dir : class_2350.values()) {
                this.invalidators[dir.ordinal()] = () -> invalidate.accept(dir);
            }
        }

        @Override
        public @Nullable IPeripheral get(class_2350 direction) {
            IPeripheral result = (IPeripheral)super.get(direction);
            if (result != null) {
                return result;
            }
            BlockApiCache cache = this.caches[direction.ordinal()];
            Runnable invalidate = this.invalidators[direction.ordinal()];
            return Peripherals.getGenericPeripheral(cache.getWorld(), cache.getPos(), direction.method_10153(), cache.getBlockEntity(), invalidate);
        }
    }

    private static class ComponentAccessImpl<T>
    implements ComponentAccess<T> {
        private final class_2586 owner;
        private final BlockApiLookup<T, class_2350> lookup;
        final BlockApiCache<T, class_2350>[] caches = new BlockApiCache[6];

        private ComponentAccessImpl(class_2586 owner, BlockApiLookup<T, class_2350> lookup) {
            this.owner = owner;
            this.lookup = lookup;
        }

        @Override
        public @Nullable T get(class_2350 direction) {
            BlockApiCache cache = this.caches[direction.ordinal()];
            if (cache == null) {
                BlockApiCache blockApiCache = BlockApiCache.create(this.lookup, (class_3218)this.getLevel(), (class_2338)this.owner.method_11016().method_10093(direction));
                this.caches[direction.ordinal()] = blockApiCache;
                cache = blockApiCache;
            }
            return (T)cache.find((Object)direction.method_10153());
        }

        private class_3218 getLevel() {
            return Objects.requireNonNull((class_3218)this.owner.method_10997(), "Block entity is not in a level");
        }
    }

    private static final class RegistryEntryImpl<T>
    implements RegistryEntry<T> {
        private final class_2960 id;
        private final Supplier<T> supplier;
        private @Nullable T instance;

        RegistryEntryImpl(class_2960 id, Supplier<T> supplier) {
            this.id = id;
            this.supplier = supplier;
        }

        void register(class_2378<? super T> registry) {
            this.instance = this.supplier.get();
            class_2378.method_10230(registry, (class_2960)this.id, this.instance);
        }

        @Override
        public class_2960 id() {
            return this.id;
        }

        @Override
        public T get() {
            if (this.instance == null) {
                throw new IllegalStateException(String.valueOf(this.id) + " has not been constructed yet");
            }
            return this.instance;
        }
    }
}

